#include "stdafx.h"
#include "win_demo.h"
#include "DialogRecordPolicy.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;

IMPLEMENT_DYNAMIC(CDialogRecordPolicy, CDialogEx)

CDialogRecordPolicy::CDialogRecordPolicy(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_RECORD_POLICY, pParent)
{

}

CDialogRecordPolicy::~CDialogRecordPolicy()
{
}

jy_dev_record_policy_list_t strecord_policy = { 0 };
jy_dev_show_schedule_time_list_t record_schedule_time_list = { 0 };
BOOL CDialogRecordPolicy::OnInitRecordPolicy()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_dev_get_record_policy(m_handle, m_chn_option, 1, &p_result);
	if (0 == nRet)
	{
		memset(&strecord_policy, 0, sizeof(jy_dev_record_policy_list_t));
		json_perser_record_policy(p_result, &strecord_policy);
		((CButton*)GetDlgItem(IDC_CHECK_RECORD_OPEN_FLAG))->SetCheck(0);
		if (strecord_policy.record_policy_list[0].record_open_flag)
		{
			((CButton*)GetDlgItem(IDC_CHECK_RECORD_OPEN_FLAG))->SetCheck(1);
		}
		((CButton*)GetDlgItem(IDC_CHECK_AUDIO_OPEN_FLAG))->SetCheck(0);
		if (strecord_policy.record_policy_list[0].audio_open_flag)
		{
			((CButton*)GetDlgItem(IDC_CHECK_AUDIO_OPEN_FLAG))->SetCheck(1);
		}
		m_stream_id.ResetContent();
		m_stream_id.InsertString(0, TEXT("stream1"));
		m_stream_id.InsertString(1, TEXT("stream2"));
		m_stream_id.InsertString(2, TEXT("stream3"));
		m_stream_id.InsertString(3, TEXT("stream4"));
		m_stream_id.SetCurSel(strecord_policy.record_policy_list[0].stream_id - 1);
		m_record_rult.ResetContent();
		m_record_rult.InsertString(0, TEXT("Save days"));
		m_record_rult.InsertString(1, TEXT("Loop"));
		m_record_rult.SetCurSel(1);
		m_record_week.ResetContent();
		m_record_week.InsertString(0, TEXT("Sun"));
		m_record_week.InsertString(1, TEXT("Mon"));
		m_record_week.InsertString(2, TEXT("Tue"));
		m_record_week.InsertString(3, TEXT("Wed"));
		m_record_week.InsertString(4, TEXT("Thur"));
		m_record_week.InsertString(5, TEXT("Fri"));
		m_record_week.InsertString(6, TEXT("Sat"));
		m_record_week.SetCurSel(0);

		m_dev_id.SetWindowTextA(strecord_policy.record_policy_list[0].dev_id);
		strins.Format(_T("%d"), strecord_policy.record_policy_list[0].disk_id);
		m_disk_id.SetWindowTextA(strins);
		strins.Format(_T("%d"), strecord_policy.record_policy_list[0].save_days);
		m_save_day.SetWindowTextA(strins);
		memset(&record_schedule_time_list, 0, sizeof(jy_dev_show_schedule_time_list_t));
		for (int i = 0; i < strecord_policy.record_policy_list[0].schedule_time_size; ++i)
		{
			switch (strecord_policy.record_policy_list[0].schedule_time_list[i].week_day)
			{
			case 0:
				record_schedule_time_list.show_time_list[0].schedule_time_list[record_schedule_time_list.show_time_list[0].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[0].schedule_time_list[record_schedule_time_list.show_time_list[0].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[0].schedule_time_list[record_schedule_time_list.show_time_list[0].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[0].list_size;
				break;
			case 1:
				record_schedule_time_list.show_time_list[1].schedule_time_list[record_schedule_time_list.show_time_list[1].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[1].schedule_time_list[record_schedule_time_list.show_time_list[1].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[1].schedule_time_list[record_schedule_time_list.show_time_list[1].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[1].list_size;
				break;
			case 2:
				record_schedule_time_list.show_time_list[2].schedule_time_list[record_schedule_time_list.show_time_list[2].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[2].schedule_time_list[record_schedule_time_list.show_time_list[2].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[2].schedule_time_list[record_schedule_time_list.show_time_list[2].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[2].list_size;
				break;
			case 3:
				record_schedule_time_list.show_time_list[3].schedule_time_list[record_schedule_time_list.show_time_list[3].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[3].schedule_time_list[record_schedule_time_list.show_time_list[3].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[3].schedule_time_list[record_schedule_time_list.show_time_list[3].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[3].list_size;
				break;
			case 4:
				record_schedule_time_list.show_time_list[4].schedule_time_list[record_schedule_time_list.show_time_list[4].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[4].schedule_time_list[record_schedule_time_list.show_time_list[4].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[4].schedule_time_list[record_schedule_time_list.show_time_list[4].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[4].list_size;
				break;
			case 5:
				record_schedule_time_list.show_time_list[5].schedule_time_list[record_schedule_time_list.show_time_list[5].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[5].schedule_time_list[record_schedule_time_list.show_time_list[5].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[5].schedule_time_list[record_schedule_time_list.show_time_list[5].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[5].list_size;
				break;
			case 6:
				record_schedule_time_list.show_time_list[6].schedule_time_list[record_schedule_time_list.show_time_list[6].list_size].week_day = strecord_policy.record_policy_list[0].schedule_time_list[i].week_day;
				record_schedule_time_list.show_time_list[6].schedule_time_list[record_schedule_time_list.show_time_list[6].list_size].start_time = strecord_policy.record_policy_list[0].schedule_time_list[i].start_time;
				record_schedule_time_list.show_time_list[6].schedule_time_list[record_schedule_time_list.show_time_list[6].list_size].end_time = strecord_policy.record_policy_list[0].schedule_time_list[i].end_time;
				++record_schedule_time_list.show_time_list[6].list_size;
				break;
			default:break;
			}
		}
		OnCbnSelchangeComboRecordDate();
		OnCbnSelchangeComboRecordRule();
	}
	return TRUE;
}

void CDialogRecordPolicy::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_DEVICE_ID, m_dev_id);
	DDX_Control(pDX, IDC_EDIT_DISK_ID, m_disk_id);
	DDX_Control(pDX, IDC_EDIT_SAVE_DAY, m_save_day);
	DDX_Control(pDX, IDC_COMBO_STREAM_ID, m_stream_id);
	DDX_Control(pDX, IDC_COMBO_RECORD_RULE, m_record_rult);
	DDX_Control(pDX, IDC_COMBO_RECORD_DATE, m_record_week);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H1, m_start_time_h1);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M1, m_start_time_m1);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H1, m_end_time_h1);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M1, m_end_time_m1);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H2, m_start_time_h2);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M2, m_start_time_m2);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H2, m_end_time_h2);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M2, m_end_time_m2);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H3, m_start_time_h3);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M3, m_start_time_m3);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H3, m_end_time_h3);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M3, m_end_time_m3);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H4, m_start_time_h4);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M4, m_start_time_m4);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H4, m_end_time_h4);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M4, m_end_time_m4);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H5, m_start_time_h5);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M5, m_start_time_m5);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H5, m_end_time_h5);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M5, m_end_time_m5);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H6, m_start_time_h6);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M6, m_start_time_m6);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H6, m_end_time_h6);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M6, m_end_time_m6);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H7, m_start_time_h7);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M7, m_start_time_m7);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H7, m_end_time_h7);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M7, m_end_time_m7);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_H8, m_start_time_h8);
	DDX_Control(pDX, IDC_EDIT_RECORD_START_TIME_M8, m_start_time_m8);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_H8, m_end_time_h8);
	DDX_Control(pDX, IDC_EDIT_RECORD_END_TIME_M8, m_end_time_m8);
}


BEGIN_MESSAGE_MAP(CDialogRecordPolicy, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORD_DATE, &CDialogRecordPolicy::OnCbnSelchangeComboRecordDate)
	ON_BN_CLICKED(IDOK, &CDialogRecordPolicy::OnBnClickedOk)
	ON_BN_CLICKED(IDOK2, &CDialogRecordPolicy::OnBnClickedOk2)
	ON_CBN_SELCHANGE(IDC_COMBO_RECORD_RULE, &CDialogRecordPolicy::OnCbnSelchangeComboRecordRule)
END_MESSAGE_MAP()

static int conversion_time (int src_time, int &res_hours, int &res_min)
{
	res_hours = src_time / 3600;
	res_min = (src_time - (res_hours * 3600)) / 60;
	return 0;
}

void CDialogRecordPolicy::show_date_info(int week, jy_dev_show_schedule_time_list_t *schedule_time_list)
{
	CString strins;
	int start_hours;
	int start_min;
	int end_hours;
	int end_min;
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m1.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m2.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m3.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m4.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m5.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m6.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m7.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m8.SetWindowTextA(strins);
}


void CDialogRecordPolicy::OnCbnSelchangeComboRecordDate()
{
	int week = m_record_week.GetCurSel();
	show_date_info(week, &record_schedule_time_list);
}

void CDialogRecordPolicy::OnCbnSelchangeComboRecordRule()
{
	CString strins;
	int nRecordRule = m_record_rult.GetCurSel();
	if (0 == nRecordRule)
	{
		(CEdit *)GetDlgItem(IDC_STATIC_SAVE_DAY)->ShowWindow(TRUE);
		(CEdit *)GetDlgItem(IDC_EDIT_SAVE_DAY)->ShowWindow(TRUE);
		strins.Format(_T("%d"), strecord_policy.record_policy_list[0].save_days);
		m_save_day.SetWindowTextA(strins);
	}
	else
	{
		(CEdit *)GetDlgItem(IDC_STATIC_SAVE_DAY)->ShowWindow(FALSE);
		(CEdit *)GetDlgItem(IDC_EDIT_SAVE_DAY)->ShowWindow(FALSE);
	}
}

void CDialogRecordPolicy::OnBnClickedOk2()
{
	CString str_tmp;
	int tmp_start_hours;
	int tmp_start_min;
	int tmp_end_hours;
	int tmp_end_min;
	int week = m_record_week.GetCurSel();
	memset(&record_schedule_time_list.show_time_list[week], 0, sizeof(jy_dev_show_schedule_time_t));
	m_start_time_h1.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m1.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h1.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m1.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) < ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[0].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[0].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[0].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h2.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m2.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h2.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m2.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[1].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[1].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[1].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h3.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m3.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h3.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m3.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[2].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[2].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[2].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h4.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m4.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h4.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m4.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[3].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[3].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[3].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h5.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m5.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h5.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m5.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[4].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[4].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[4].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h6.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m6.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h6.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m6.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[5].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[5].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[5].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h7.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m7.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h7.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m7.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[6].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[6].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[6].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h8.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m8.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h8.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m8.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			record_schedule_time_list.show_time_list[week].schedule_time_list[7].week_day = week;
			record_schedule_time_list.show_time_list[week].schedule_time_list[7].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			record_schedule_time_list.show_time_list[week].schedule_time_list[7].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++record_schedule_time_list.show_time_list[week].list_size;
	}
}

void CDialogRecordPolicy::OnBnClickedOk()
{
	CDialogEx::OnOK();
	CString str_tmp;
	int schedule_size = 0;
	char *p_param = NULL;
	strecord_policy.record_policy_list[0].record_open_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_RECORD_OPEN_FLAG))->GetCheck() == TRUE)
	{
		strecord_policy.record_policy_list[0].record_open_flag = 1;
	}
	strecord_policy.record_policy_list[0].audio_open_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_AUDIO_OPEN_FLAG))->GetCheck() == TRUE)
	{
		strecord_policy.record_policy_list[0].audio_open_flag = 1;
	}
	strecord_policy.record_policy_list[0].stream_id = m_stream_id.GetCurSel() + 1;
	int nRecordRule = m_record_rult.GetCurSel();
	if (0 == nRecordRule)
	{
		m_save_day.GetWindowText(str_tmp);
		strecord_policy.record_policy_list[0].save_days = _ttoi(str_tmp);;
	}
	else
	{
		strecord_policy.record_policy_list[0].save_days = 0;
	}
	m_disk_id.GetWindowText(str_tmp);
	strecord_policy.record_policy_list[0].disk_id = _ttoi(str_tmp);
	for (int i = 0; i < 7; ++i)
	{
		for (int j = 0; j < record_schedule_time_list.show_time_list[i].list_size; ++j)
		{
			strecord_policy.record_policy_list[0].schedule_time_list[schedule_size].week_day = record_schedule_time_list.show_time_list[i].schedule_time_list[j].week_day;
			strecord_policy.record_policy_list[0].schedule_time_list[schedule_size].start_time = record_schedule_time_list.show_time_list[i].schedule_time_list[j].start_time;
			strecord_policy.record_policy_list[0].schedule_time_list[schedule_size].end_time = record_schedule_time_list.show_time_list[i].schedule_time_list[j].end_time;
			++schedule_size;
		}
	}
	strecord_policy.record_policy_list[0].schedule_time_size = schedule_size;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set your video policy?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_record_policy(&strecord_policy, &p_param);
		int nRet = sdks_dev_set_record_policy(m_handle, m_chn_option, p_param);
		if (nRet) {
			MessageBoxA("Set record policy param fail!");
		}
	}
}